<?php

namespace App\Entities\Lecturers;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lecturer extends Model 
{

    protected $table = 'lecturers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function courses()
    {
        return $this->hasMany('Course');
    }

    public function bookings()
    {
        return $this->hasMany('Booking');
    }

}